#!/usr/bin/python


# Usage = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 

# First, launch Wiimote Connect program to interface with Wiimote
# Sync Wiimote by pressing 1 + 2 buttons simultaneously

# Open Terminal and change directory to this file's location
# Then type the following line into the Terminal (without the #)
# tail -f /tmp/wiipipe | python wiitunes.py

# Terminal window will display roll/pitch/yaw info for Wiimote

# Hold B button while moving to execute a gesture command
# When a gesture command is recognized, the name appears

# Hit ctrl-c to exit







# Applescript = = = = = = = = = = = = = = = = = = = = = = = = = =


import sys, os

def run_command(command):
	script = os.popen("osascript", "w")
	script.write('tell application "iTunes"\r\n')
	script.write("%s\r\n" % command)
	script.write('end tell\r\n')
	script.close()


def set_volume(dir):
	script = os.popen("osascript", "w")
	if dir=="down":
		s = """
			tell application "iTunes"
				set old_vol to sound volume
				set new_vol to old_vol - 15
				repeat with i from old_vol to new_vol by -1
					set sound volume to i
				end repeat
			end tell
		"""
	elif dir=="up":
		s = """
			tell application "iTunes"
				set old_vol to sound volume
				set new_vol to old_vol + 15
				repeat with i from old_vol to new_vol by 1
					set sound volume to i
				end repeat
			end tell
		"""
	script.write(s)
	script.close()


def reset_track():
	script = os.popen("osascript", "w")
	s = """
		tell application "iTunes"
			previous track
			next track
		end tell
	"""
	script.write(s)
	script.close()


def set_playlist(dir):
	script = os.popen("osascript", "w")
	if dir=="previous":
		s = """
		
			set theVoice to "Vicki"
			
			tell application "iTunes"
				
				set allLists to playlists
				name of every playlist
				set curList to current playlist
				name of curList
				
				set i to 1
				
				-- find the current playlists index in the list of playlists 
				repeat with theList in every playlist
					name of theList
					if name of curList is equal to name of theList then
						exit repeat
					end if
					set i to i + 1
				end repeat
				
				-- now increment one more in your index to get the next playlist 
				set i to i - 1
				
				try
					-- finally return the playlist you found 
					set newList to item i of allLists
					set playL to name of newList
					set speechText to "[[volm .2; rate 200; emph -]] list:" & playL
					say speechText using theVoice
					play track 1 of playlist playL
					set view of front browser window to playlist playL
				end try
				
			end tell
		"""
	elif dir=="next":
		s = """
		
			set theVoice to "Vicki"
		
			tell application "iTunes"
				
				set allLists to playlists
				name of every playlist
				set curList to current playlist
				name of curList
				
				set i to 1
				
				-- find the current playlists index in the list of playlists 
				repeat with theList in every playlist
					name of theList
					if name of curList is equal to name of theList then
						exit repeat
					end if
					set i to i + 1
				end repeat
				
				-- now increment one more in your index to get the next playlist 
				set i to i + 1
				
				try
					-- finally return the playlist you found 
					set newList to item i of allLists
					set playL to name of newList
					set speechText to "[[volm .2; rate 200; emph -]] list:" & playL
					say speechText using theVoice
					play track 1 of playlist playL
					set view of front browser window to playlist playL					
				end try
				
			end tell
		"""
	script.write(s)
	script.close()












# Setup = = = = = = = = = = = = = = = = = = = = = = = = = =

#the following library is only needed with Arduino
#import serial #pyserial libary


play = 1

since = 0
r_floater = 0
p_floater = 0
y_floater = 0

a_floater = 0
b_floater = 0

capture = 0
action = 0
decay = 0
sample = 0
count = 0
gate = 0

ir = [1,1,1,1,1,1]
ip = [1,1,1,1,1,1]
iy = [1,1,1,1,1,1]

dr = [1,1,1,1,1,1]
dp = [1,1,1,1,1,1]
dy = [1,1,1,1,1,1]










# Motion Capture = = = = = = = = = = = = = = = = = = = = = 

while 1:
	try:
		line = sys.stdin.readline()
		since += 1
		r = int(line.split()[0])
		p = int(line.split()[1])
		y = int(line.split()[2])
		
		a = int(line.split()[3])
		b = int(line.split()[4])
		
		
		#process the A button press first	

		if a != a_floater and a == 1:
			action = 1
			behavior = "playpause"

		#if b != b_floater and b == 1:
		#	action = 1
		#	behavior = "bringfront"			
		
		
		
		delta_r = abs(r - r_floater)
		delta_p = abs(p - p_floater)
		delta_y = abs(y - y_floater)		
		
		dr.append(r)
		dp.append(p)
		dy.append(y)

		
		if delta_r > 5 or delta_p > 5 or delta_y > 5:
			sample = 1
		
		if sample:
			count+=1
			
		if count>3 and decay<1:
			count = 0
			sample = 0
			decay = 5
			
			ir[0] = dr.pop()
			ir[1] = dr.pop()
			ir[2] = dr.pop()
			ir[3] = dr.pop()
			ir[4] = dr.pop()
			ir[5] = dr.pop()
			
			ip[0] = dp.pop()
			ip[1] = dp.pop()
			ip[2] = dp.pop()
			ip[3] = dp.pop()
			ip[4] = dp.pop()
			ip[5] = dp.pop()			
			
			iy[0] = dy.pop()
			iy[1] = dy.pop()
			iy[2] = dy.pop()
			iy[3] = dy.pop()
			iy[4] = dy.pop()
			iy[5] = dy.pop()
			
			ir.reverse()
			ip.reverse()
			iy.reverse()

			total = 0

			i = 0

			lownum = highnum = high = low = 0
			tail = 0
			
			
			
			
			
			
			
			
# Motion Processing = = = = = = = = = = = = = = = = = = = = = 			
			
			
			output = ""
			output += "\nr: "	
			for val in ir:
				
				# roll tells us if we're tilting left or right
				# negative number tilt left, positive tilts right
				# ranges from -30 to 30 with no accel
				
				i+=1
				
				if i>2:
					tail += val
				
				if val<low:
					low = val
					lnum = i
				
				if val>high:
					high = val
					hnum = i

				if abs(val)>1:
					output += str(val)
				else:
					output += "."
				output += " "			
			
			tail = round(tail/4)
			if abs(tail) > 18:
				action = 1
				if tail<-10: behavior = "roll_left"
				if tail>10: behavior  = "roll_right"
			
			if abs(high) > 30 or abs(low) > 30:
				if abs(high) > 10 and abs(low) > 10:
					if abs(lnum-hnum) == 1 and action != 1:
						action = 1
						if lnum>hnum: behavior = "yaw_left"
						else: behavior = "yaw_right"
			
			pitch = 0
			i = 0
			output += "\np: "
			for val in ip:
				
				# pitch tells us if we're pointing up or down
				# negative numbers point up, postive point down
				# ranges from -30 to 30 with no accel
				
				i+=1
				
				if i>3:
					pitch += val
									
				if abs(val)>1:
					output += str(val)
				else:
					output += "."
				output += " "			
			
			pitch = round(pitch/3)
			if abs(pitch) > 12 and action != 1:
				action = 1
				if pitch<-10: behavior = "pitch_up"
				if pitch>10: behavior  = "pitch_down"
			
			
			output += "\ny: "
			for val in iy:
				
				if abs(val)>1:
					output += str(val)
				else:
					output += "."
				output += " "	
				
							
			print output
		
			
		if decay>0:
			decay -= 1;
		
			
		r_floater = r
		p_floater = p
		y_floater = y
		
		a_floater = a
		b_floater = b		
		
		

		# use the B button to enter/exit gesture recognition
		# you have to hold the button while you execute the gesture
		# otherwise just setting down the Wiimote makes it go crazy
		if b == 1:
			capture = 1
		if b == 0:
			capture = 0

		
		










# Execute the Commands = = = = = = = = = = = = = = = = = = = = = = = = = 
	
		
		if action and since > 5: # ignore commands for 0.25 seconds
			
			#print capture
			if capture and play:
				print behavior
			
			action = 0
			decay = 5
			
			
			# blink the light on the Arduino board
			#ser = serial.Serial('/dev/tty.usbserial-A5001auD', 9600, timeout=1)
			#ser.write("H")
			#ser.close() 
			
			
			if behavior == "playpause":
				if play:
					run_command("pause")
					play = 0
					print "+ + +"
				else:
					run_command("play")
					play = 1
			
			if capture and play:
				if behavior == "bringfront":
					run_command("activate") #deactived
				
				elif behavior == "yaw_right":
					set_playlist("next")
					
				elif behavior == "yaw_left":
					set_playlist("previous")
				
				elif behavior == "roll_right":
					run_command("next track")
				
				elif behavior == "roll_left":
					run_command("previous track")
				
				elif behavior == "pitch_up":
					set_volume("up")
				
				elif behavior == "pitch_down":
					set_volume("down")
			
				print "+ + +"
			




# Handle Errors = = = = = = = = = = = = = = = = = = = = = = = = = 
# Hit ctrl-c to exit

	except KeyboardInterrupt:
		sys.exit(0)
	
	except (IndexError,TypeError):
		print sys.exc_info()[0] 
	except:
		pass


